<!doctype html>
<html lang="id">
    <head>
        <title>Stockify - Sistem Informasi Ketersediaan Obat</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=0,minimal-ui">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta description="Stockify - Sistem Informasi Ketersediaan Obat dengan Data Real-Time Menggunakan Metode Economic Order Quantity (EOQ) di Puskesmas Bontomarannu">
        <link rel="icon" href="assets/images/logo.png" type="image/x-icon">
        <link href="assets/css/plugins/animate.min.css" rel="stylesheet" type="text/css">
        <link href="assets/css/plugins/swiper-bundle.css" rel="stylesheet">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
        <link rel="stylesheet" href="assets/fonts/tabler-icons.min.css">
        <link rel="stylesheet" href="assets/css/style.css">
        <link rel="stylesheet" href="assets/css/style-preset.css">
        <link rel="stylesheet" href="assets/css/landing.css">
        <style>
            .feature-card {
                transition: all 0.3s ease;
                border: none;
                box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            }
            .feature-card:hover {
                transform: translateY(-5px);
                box-shadow: 0 8px 30px rgba(13, 110, 253, 0.15);
            }
            .feature-icon {
                width: 70px;
                height: 70px;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 20px;
            }
        </style>
    </head>
    <body class="landing-page">
        <div class="loader-bg">
            <div class="loader-track">
                <div class="loader-fill"></div>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="navbar navbar-expand-md navbar-light default">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <img src="assets/images/banner.png" alt="" width="150px">
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarTogglerDemo01" aria-controls="navbarTogglerDemo01" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarTogglerDemo01">
                    <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link active" href="#home">Beranda</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#features">Fitur</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#benefits">Manfaat</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link me-2" href="#about">Tentang</a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn-success" href="login.php">Login</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Hero Section -->
        <header id="home">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-lg-6 col-xl-5">
                        <h1 class="mt-sm-3 mb-sm-4 f-w-600">
                            Kelola Ketersediaan Obat dengan <span class="text-success">STOCKIFY</span>
                        </h1>
                        <h4 class="mb-sm-4 text-muted">Sistem Informasi Ketersediaan Obat dengan Data Real-Time Menggunakan Metode Economic Order Quantity (EOQ) untuk manajemen stok obat yang optimal di Puskesmas Bontomarannu.</h4>
                        <div class="my-3 my-xl-5">
                            <a href="login.php" class="btn btn-success me-2">Mulai Sekarang</a>
                            <a href="#features" class="btn btn-link-success">Lihat Fitur</a>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="hero-image text-center">
                            <img src="assets/images/1.svg" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Fitur Section -->
        <section id="features" class="bg-light py-5">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-12 text-center">
                        <h2 class="h1">Fitur Utama Stockify</h2>
                        <p class="text-muted">Sistem kami menyediakan segala kebutuhan manajemen ketersediaan obat digital Anda</p>
                    </div>
                </div>
                <div class="row g-4">
                    <!-- Fitur 1 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-success-light text-success">
                                    <i class="ti ti-package fs-1"></i>
                                </div>
                                <h3 class="my-3">Manajemen Stok Obat</h3>
                                <p>Kelola stok obat di berbagai gudang dengan sistem pencatatan yang akurat dan real-time. Pantau jumlah stok setiap obat kapan saja.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 2 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-success-light text-success">
                                    <i class="ti ti-calculator fs-1"></i>
                                </div>
                                <h3 class="my-3">Kalkulasi EOQ Otomatis</h3>
                                <p>Sistem menghitung Economic Order Quantity secara otomatis berdasarkan data permintaan dan biaya persediaan untuk pemesanan optimal.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 3 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-info-light text-info">
                                    <i class="ti ti-alert-circle fs-1"></i>
                                </div>
                                <h3 class="my-3">Alert & Notifikasi</h3>
                                <p>Dapatkan notifikasi otomatis ketika stok obat mencapai reorder point atau safety stock untuk mencegah kehabisan stok.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 4 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-warning-light text-warning">
                                    <i class="ti ti-chart-bar fs-1"></i>
                                </div>
                                <h3 class="my-3">Laporan Stok Real-Time</h3>
                                <p>Hasilkan laporan ketersediaan obat, mutasi stok, dan analisis distribusi gudang secara real-time dan akurat.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 5 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-danger-light text-danger">
                                    <i class="ti ti-cash-banknote fs-1"></i>
                                </div>
                                <h3 class="my-3">Mutasi Stok Digital</h3>
                                <p>Catat setiap pergerakan stok obat baik masuk maupun keluar dengan dokumentasi yang lengkap dan terstruktur.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 6 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-secondary-light text-secondary">
                                    <i class="ti ti-scan fs-1"></i>
                                </div>
                                <h3 class="my-3">Scan Barcode</h3>
                                <p>Scan barcode obat untuk mempercepat pencatatan dan meminimalkan kesalahan input data stok obat.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 7 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-indigo-light text-success">
                                    <i class="ti ti-shopping-cart fs-1"></i>
                                </div>
                                <h3 class="my-3">Manajemen Pembelian</h3>
                                <p>Kelola proses pembelian obat dari supplier dengan sistem approval yang terintegrasi dan terukur.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 8 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-cyan-light text-info">
                                    <i class="ti ti-users fs-1"></i>
                                </div>
                                <h3 class="my-3">Multi User & Role</h3>
                                <p>Sistem dengan berbagai role pengguna (Apoteker, Petugas Gudang, Kepala Puskesmas) untuk manajemen akses terkontrol.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Fitur 9 -->
                    <div class="col-md-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <div class="feature-icon bg-teal-light text-danger">
                                    <i class="ti ti-database fs-1"></i>
                                </div>
                                <h3 class="my-3">Database Terintegrasi</h3>
                                <p>Semua data obat, stok, supplier, dan pembelian tercatat dalam satu database terpusat yang aman dan terintegrasi.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Benefits Section -->
        <section id="benefits" class="bg-body py-5">
            <div class="container">
                <div class="row align-items-center g-4">
                    <div class="col-md-6 text-center">
                        <img src="assets/images/2.svg" alt="">
                    </div>
                    <div class="col-md-6">
                        <h2 class="h1">Manfaat Menggunakan Stockify</h2>
                        <ul class="list-unstyled customize-list">
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Pencatatan stok obat yang akurat dan real-time</li>
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Optimalisasi pemesanan obat dengan metode EOQ</li>
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Pencegahan kehabisan stok obat penting</li>
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Efisiensi biaya persediaan obat</li>
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Transparansi data ketersediaan obat</li>
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Kemudahan akses data kapan saja dari mana saja</li>
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Pengambilan keputusan berbasis data real-time</li>
                            <li><i class="ti ti-circle-check f-20 text-success"></i> Laporan stok yang akurat untuk perencanaan</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <!-- About Section -->
        <section id="about" class="bg-light py-5">
            <div class="container">
                <div class="row align-items-center g-4">
                    <div class="col-md-6">
                        <h2 class="h1">Tentang Stockify</h2>
                        <p class="text-lg my-3">
                            Stockify adalah Sistem Informasi Ketersediaan Obat dengan Data Real-Time yang dirancang khusus untuk membantu Puskesmas Bontomarannu dalam mengelola ketersediaan obat secara digital dan efisien.
                        </p>
                        <p class="text-lg my-3">
                            Sistem ini mengimplementasikan metode Economic Order Quantity (EOQ) untuk mengoptimalkan pemesanan obat, mengurangi biaya persediaan, dan memastikan ketersediaan obat yang cukup untuk melayani masyarakat tanpa khawatir kehabisan stok.
                        </p>
                        <p class="text-muted small">
                            Dikembangkan sebagai Sistem Informasi untuk memenuhi kebutuhan manajemen stok obat modern dengan teknologi terkini dan interface yang user-friendly.
                        </p>
                        <div class="d-flex align-items-center mt-4">
                            <div class="me-4">
                                <h3 class="text-success mb-0">Real-Time</h3>
                                <p class="text-muted mb-0">Data Updates</p>
                            </div>
                            <div class="me-4">
                                <h3 class="text-success mb-0">100%</h3>
                                <p class="text-muted mb-0">Akurat</p>
                            </div>
                            <div>
                                <h3 class="text-success mb-0">EOQ</h3>
                                <p class="text-muted mb-0">Optimization</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 text-center">
                        <img src="assets/images/apoteker.svg" alt="">
                    </div>
                </div>
            </div>
        </section>

        <!-- Info Section -->
        <section class="bg-success text-white py-5">
            <div class="container">
                <div class="row text-center">
                    <div class="col-md-4 mb-3 mb-md-0">
                        <h3 class="text-white">Untuk Puskesmas</h3>
                        <p class="mb-0">Kelola ketersediaan obat dengan mudah dan efisien</p>
                    </div>
                    <div class="col-md-4 mb-3 mb-md-0">
                        <h3 class="text-white">Real-Time System</h3>
                        <p class="mb-0">Data selalu update kapan saja dibutuhkan</p>
                    </div>
                    <div class="col-md-4">
                        <h3 class="text-white">EOQ Method</h3>
                        <p class="mb-0">Optimalisasi pemesanan obat terpercaya</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer class="bg-dark text-white py-4">
            <div class="container">
                <div class="row">
                    <div class="col-12 text-center">
                        <p class="mb-1">Sistem Informasi Ketersediaan Obat dengan Data Real-Time</p>
                        <p class="mb-0">Menggunakan Metode Economic Order Quantity (EOQ)</p>
                        <p class="mb-0 mt-3"><small>© 2025 Puskesmas Bontomarannu. All rights reserved.</small></p>
                    </div>
                </div>
            </div>
        </footer>

        <script src="assets/js/plugins/popper.min.js"></script>
        <script src="assets/js/plugins/bootstrap.min.js"></script>
        <script src="assets/js/plugins/wow.min.js"></script>
        <script>
            new WOW().init();
        </script>
        <script>
            preset_change("preset-5");
        </script>
    </body>
</html>